<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Escuela Profesional de Psicología - Facultad de Educación y Humanidades - UNSM">
    <meta name="keywords" content="UNSM, Psicología, Educación y Humanidades, Universidad San Martin">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#6B5B95">

    <title>Escuela de Psicología - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Educación y Humanidades -->
    <link rel="stylesheet" href="../css/styleEdu.css">
    <!-- Stylesheet Psicología -->
    <link rel="stylesheet" href="css/stylePsico.css?v=2.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en Facebook" aria-label="Página oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Síguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Síguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Síguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Teléfono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la página principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martín" width="auto" height="70">
                </a>
            </div>

            <!-- Botón Hamburguesa para móvil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menú de navegación" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegación principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menú Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Misión y Visión</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Académico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menú Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Académico</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../admision/indexAdmin.php">ADMISIÓN</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menú Facultades">
                            <li class="has-submenu">
                                <a href="../../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../ciencias agrarias/agronomia/indexAgro.php">Agronomía</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="#educacion" aria-haspopup="true" aria-expanded="false">Educación y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educación">
                                    <li><a href="#educacion-inicial">Educación Inicial</a></li>
                                    <li><a href="#educacion-primaria">Educación Primaria</a></li>
                                    <li><a href="#educacion-secundaria">Educación Secundaria</a></li>
                                    <li><a href="./indexPsico.php">Psicología</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Perú">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Perú">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Perú" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Psicología -->
    <section class="psico-banner">
        <div class="banner-image">
            <img src="https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?w=1600" alt="Profesional de psicología">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-content-wrapper">
            <div class="banner-header">
                <div class="banner-logo">
                    <img src="../../../imagenes/Escudos de Facultades — UNSM/FEDU-UNSM-2021.png" alt="Logo Facultad de Educación y Humanidades" width="80" height="80" onerror="this.style.display='none'">
                </div>
                <div class="banner-title-section">
                    <h1>ESCUELA DE PSICOLOGÍA <span class="badge-nuevo">Nueva</span></h1>
                    <p class="banner-breadcrumb">📍 Facultad de Educación y Humanidades</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Información con Tabs -->
    <section class="info-section">
        <div class="info-container">
            <div class="tabs-wrapper">
                <div class="tabs-buttons">
                    <button class="tab-button active" data-tab="resena">RESEÑA</button>
                    <button class="tab-button" data-tab="mision">MISIÓN</button>
                    <button class="tab-button" data-tab="vision">VISIÓN</button>
                </div>

                <div class="tabs-content">
                    <div class="tab-content active" id="resena">
                        <p>La Escuela Profesional de Psicología forma profesionales competentes en el estudio científico del comportamiento humano y los procesos mentales. Nuestros egresados cuentan con sólida formación en evaluación, diagnóstico e intervención psicológica en diversos contextos: clínico, educativo, organizacional y comunitario.</p>
                        <p>Desarrollamos competencias para la investigación científica, promoviendo el bienestar psicológico y la salud mental de individuos, grupos y comunidades, con enfoque humanista, ético y compromiso social hacia el desarrollo de la región San Martín y el país.</p>
                    </div>
                    <div class="tab-content" id="mision">
                        <p>Formar profesionales en psicología con sólidos conocimientos científicos, tecnológicos y humanísticos, capaces de contribuir al bienestar psicológico y la salud mental de la población, mediante la investigación, innovación e intervención psicológica basada en evidencia científica.</p>
                    </div>
                    <div class="tab-content" id="vision">
                        <p>Ser una escuela profesional líder en la formación de psicólogos competitivos y comprometidos con la salud mental y el desarrollo humano, reconocida por su excelencia académica, investigación científica e intervención psicológica al servicio de la sociedad.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Carrera Profesional -->
    <section class="carrera-section">
        <div class="carrera-container">
            <div class="carrera-header">
                <h2>CARRERA PROFESIONAL: PSICOLOGÍA</h2>
            </div>

            <div class="carrera-info-grid">
                <div class="info-card">
                    <div class="info-icon">📅</div>
                    <div class="info-details">
                        <h3>DURACIÓN DE LA CARRERA</h3>
                        <p>10 semestres académicos (5 años)</p>
                    </div>
                </div>

                <div class="info-card">
                    <div class="info-icon">📚</div>
                    <div class="info-details">
                        <h3>GRADO ACADÉMICO</h3>
                        <p>Bachiller en Psicología</p>
                    </div>
                </div>

                <div class="info-card">
                    <div class="info-icon">🎓</div>
                    <div class="info-details">
                        <h3>TÍTULO PROFESIONAL</h3>
                        <p>Licenciado(a) en Psicología</p>
                    </div>
                </div>

                <div class="info-card">
                    <div class="info-icon">📋</div>
                    <div class="info-details">
                        <h3>MODALIDAD</h3>
                        <p>Presencial</p>
                    </div>
                </div>
            </div>

            <!-- Objetivos de la Carrera -->
            <div class="objetivos-section">
                <h3>OBJETIVOS DE LA CARRERA</h3>
                <ul class="objetivos-list">
                    <li>Formar profesionales con sólidos conocimientos en las áreas de la psicología clínica, educativa, organizacional y social.</li>
                    <li>Desarrollar competencias en evaluación, diagnóstico e intervención psicológica basada en evidencia científica.</li>
                    <li>Promover la investigación científica para generar conocimiento sobre el comportamiento humano y la salud mental.</li>
                    <li>Contribuir al bienestar psicológico y la salud mental de la población regional y nacional.</li>
                    <li>Formar profesionales con valores éticos, respeto por la diversidad y compromiso social.</li>
                </ul>
            </div>

            <!-- Áreas de Especialización -->
            <div class="areas-section">
                <h3>ÁREAS DE ESPECIALIZACIÓN</h3>
                <div class="areas-grid">
                    <div class="area-card">
                        <h4>🏥 Psicología Clínica y de la Salud</h4>
                        <p>Evaluación, diagnóstico y tratamiento de trastornos mentales y emocionales en hospitales, clínicas y centros de salud mental.</p>
                    </div>
                    <div class="area-card">
                        <h4>🎓 Psicología Educativa</h4>
                        <p>Intervención en procesos de enseñanza-aprendizaje, orientación vocacional y atención a necesidades educativas especiales.</p>
                    </div>
                    <div class="area-card">
                        <h4>💼 Psicología Organizacional</h4>
                        <p>Gestión del talento humano, desarrollo organizacional, selección de personal y bienestar laboral.</p>
                    </div>
                    <div class="area-card">
                        <h4>🤝 Psicología Comunitaria y Social</h4>
                        <p>Promoción del bienestar social, desarrollo comunitario y prevención en salud mental.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Sección Noticias Recientes -->
    <section class="noticias-section">
        <div class="noticias-container">
            <h2>NOTICIAS RECIENTES</h2>
            <div class="noticias-grid">
                <article class="noticia-card">
                    <div class="noticia-image">
                        <img src="https://images.unsplash.com/photo-1516534775068-ba3e7458af70?w=800" alt="Estudiantes de psicología">
                        <span class="noticia-badge">ACADÉMICO</span>
                    </div>
                    <div class="noticia-content">
                        <h3>Inicio de la nueva carrera profesional de Psicología</h3>
                        <p>La UNSM da la bienvenida a la primera promoción de estudiantes de Psicología, con una moderna infraestructura y docentes especializados.</p>
                        <a href="#" class="noticia-link">Leer más →</a>
                    </div>
                </article>

                <article class="noticia-card">
                    <div class="noticia-image">
                        <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=800" alt="Investigación en psicología">
                        <span class="noticia-badge">INVESTIGACIÓN</span>
                    </div>
                    <div class="noticia-content">
                        <h3>Convenios con instituciones de salud mental</h3>
                        <p>Se establecen alianzas estratégicas para las prácticas preprofesionales de nuestros estudiantes en centros de salud de la región.</p>
                        <a href="#" class="noticia-link">Leer más →</a>
                    </div>
                </article>

                <article class="noticia-card">
                    <div class="noticia-image">
                        <img src="https://images.unsplash.com/photo-1573497019940-1c28c88b4f3e?w=800" alt="Servicios psicológicos">
                        <span class="noticia-badge">EVENTOS</span>
                    </div>
                    <div class="noticia-content">
                        <h3>Centro de servicios psicológicos para la comunidad</h3>
                        <p>Próxima apertura del centro de atención psicológica gratuita para la comunidad universitaria y población en general.</p>
                        <a href="#" class="noticia-link">Leer más →</a>
                    </div>
                </article>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autónomo y de carácter estatal, comprometido con la formación de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martín - Perú</p>
                    <p>Central Telefónica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rápidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../admision/indexAdmin.php">Admisión</a></li>
                    <li><a href="../../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../../index.php#investigacion">Investigación</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martín - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martín. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Síguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../../js/script.js" defer></script>
    <script>
        // Tabs functionality
        document.addEventListener('DOMContentLoaded', function() {
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tab-content');

            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetTab = this.getAttribute('data-tab');

                    // Remove active class from all buttons and contents
                    tabButtons.forEach(btn => btn.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    // Add active class to clicked button and corresponding content
                    this.classList.add('active');
                    document.getElementById(targetTab).classList.add('active');
                });
            });
        });
    </script>
</body>
</html>
